/*
 *  IBDocument+Private.h
 *  
 *
 *  Created by Kai on 23.1.08.
 *  Copyright 2008 __MyCompanyName__. All rights reserved.
 *
 */

/*
 IBDocument.h
 Interface Builder Kit
 Copyright (c) 2006-2007 Apple Inc.
 All rights reserved.
 
 A IBDocument object provides the in-memory representation of a nib file. The IBDocument class is one of the core classes in Interface Builder. It manages all of the objects in a nib file, observes them for undo support, and facilitates the general exchange of information with other objects
 */

#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5

#import <Cocoa/Cocoa.h>



@interface IBDocument : NSDocument {
}

/* Returns the NSDocument subclass containing the specified object. */
+ (id)documentForObject:(id)object;

/* Returns collections of all objects and top-level objects in the document file.*/
- (NSArray *)objects;
- (NSArray *)topLevelObjects;

/* Access to the children and parent of a given object */
- (NSArray *)childrenOfObject:(id)object;
- (id)parentOfObject:(id)object;

/* Adds and removes items from the document, setting up the parent relationship where necessary. */
- (void)addObject:(id)object toParent:(id)parent;
- (void)removeObject:(id)object;
- (void)moveObject:(id)object toParent:(id)parent;

/* Metadata and resource management */
- (void)setMetadata:(id)value forKey:(NSString *)key ofObject:(id)object;
- (id)metadataForKey:(NSString *)key ofObject:(id)object;
- (NSImage *)documentImageNamed:(NSString *)name;

/* Methods to connect outlets, actions, and bindings between objects */
- (void)connectOutlet:(NSString *)outletName ofSourceObject:(id)source toDestinationObject:(id)destination;
- (void)connectAction:(NSString *)selectorName ofSourceObject:(id)source toDestinationObject:(id)destination;
- (void)connectBinding:(NSString *)bindingName ofSourceObject:(id)source toDestinationObject:(id)destination keyPath:(NSString *)keyPath options:(NSDictionary *)options;

// Additional methods which are not documented in 10.5.1:
- (NSArray*) connections;
- (NSArray*) connectionsForObject:(id)object;
- (NSArray*) connectionsFromObject:(id)object;
- (NSArray*) connectionsToObject:(id)object;

@end

#endif

